//--------------------------------------------------------------------
// Microsoft OLE DB Sample Consumer
// (C) Copyright 1995 - 1997 Microsoft Corporation. All Rights Reserved.
//
// File name: SAMPCLNT.CPP
//
//      Implementation file for a simple OLE DB consumer.
//      Dump\output routines for SAMPCLNT are in DUMP.CPP
//      SAMPCLNT.H is the header file.
//
//      See MyOLEDB Provider Guide for information on building and running 
//		this sample.
//
// Functions:
//
//      See SAMPCLNT.H for function prototypes
//
// 
// SampClnt is structured to match the steps required for simple OLE DB data access:
// 
// 	DoTests
// 		GetSampprovDataSource
//      GetDBSessionFromDataSource
//      GetCommandFromDBSession
// 		GetDataFromRowset
// 			GetColumnsInfo
// 			SetupBindings
// 			CreateAccessor
// 			GetData
// 			CleanupRowset
// 


#define INITGUID
#define DBINITCONSTANTS
#include "sampclnt.h"
#include "..\_include\testconf.h"


IMalloc* g_pIMalloc = NULL;
FILE*    g_fpLogFile = NULL;    // our log file




//**********************************************************************
// 
// main
// 
// Purpose:
//
//     Entry point for this program.
// 
// Parameters:
//
//     none
//     
// Return Value:
//
//     none
// 
// Comments:      
//
//     Main does some initializing, then calls DoTests, then cleans up.
//     All of the interesting action in this program happens in DoTests.
// 
//**********************************************************************


void main()
{
	DWORD   dwVersion;
	HRESULT hr;
	time_t	ttime;
    BOOL 	fOleInitialized = FALSE;
	char	ch;
	
  	g_fpLogFile = fopen( DEF_LOG_FILE_FULL_NAME, "w" );
    if (!g_fpLogFile)
    	{
    	DumpErrorMsg( "Warning: cannot open log file \n" );
        }
  
  	time(&ttime);
    
    DumpStatusMsg( "\n-------------------------\n\n");
    DumpStatusMsg( "running sampclnt.exe\n%s\n\n", ctime(&ttime) );

	dwVersion = OleBuildVersion();
    if (HIWORD(dwVersion) != rmm)
		{
		DumpErrorMsg( "Error: OLE version mismatch. Build version %ld, current version %ld\n",
			rmm, HIWORD(dwVersion) );
        goto error;    
		}

	hr = OleInitialize( NULL );
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorMsg("Error: OleInitialize failed\n");
        goto error;
		}
	fOleInitialized = TRUE;
     
    hr = CoGetMalloc( MEMCTX_TASK, &g_pIMalloc );
 	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorMsg("Error: CoGetMalloc failed\n");
        goto error;
        }
   
    hr = DoTests();
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "DoTests");
        goto error;
        }
    
    g_pIMalloc->Release();
	OleUninitialize();

	if (g_fpLogFile)
    	fclose(g_fpLogFile);

	/* Pause before we quit, in case user ran from an icon, so they can see our messages. */
	printf("\n\n>>> OK: Output has gone into log file.");
	printf("\n>>> You may wish to use a wide-column editor to view this file.\n\n");
	return;
    
error:
    if (g_pIMalloc)
    	g_pIMalloc->Release();    
	if (fOleInitialized)
    	OleUninitialize();
	if (g_fpLogFile)
    	fclose(g_fpLogFile);
	
	/* Pause before we quit, in case user ran from an icon, so they can see our messages. */
	printf("\n\n>>> NOK: Output has gone into log file.");
	printf("\n>>> You may wish to use a wide-column editor to view this file.\n\n");
	printf("<press any key to continue>");
	ch = _getch();

	return;    
}    



//**********************************************************************
//  
//  DoTests
//  
//  Purpose:
//
//     Hooks up to the MYSQLPROV OLE DB provider application, asks the provider
//     for all data in the CSV file CUSTOMER.CSV, and logs the resulting data 
//     to log file       
//  
//  Parameters:
//  
//  	none
//      
//  Return Value:
//  
//  	S_OK		- Success
//      E_*			- Failure
//  	
//      
//  Comments:      
//  
//     At a high level, an OLE DB data consumer obtains data by 
//     
//     1. Getting hooked up to a data provider's Data Source object,
//        and initializing that object
//     2. Getting a DBSession object from the Data Source object
//     3. Getting the data from the Rowset object.
//     
//     DoTests follows these steps by making calls to GetSampprovDataSource,
//     GetDBSessionDataSource, and GetDataFromRowset    
//  
//**********************************************************************


HRESULT DoTests
	(
	)
{
	IDBInitialize*	    pIDBInitialize 	= NULL;
    IDBCreateCommand*   pIDBCreateCommand = NULL;
    ICommand*		    pICommand		= NULL;
	ICommandText*	    pICommandText	= NULL;
	LPWSTR			    pwszTableName   = 	DEF_MYSQL_FILE;
	HRESULT			    hr;


	hr = GetSampprovDataSource( &pIDBInitialize );
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "GetSampprovDataSource" );
        goto error;
        }

    hr = GetDBSessionFromDataSource( pIDBInitialize, &pIDBCreateCommand );
    if (FAILED(hr))
        {
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "GetDBSessionFromDataSource" );
        goto error;
        }

    pIDBInitialize->Release();
    pIDBInitialize = NULL;    

    hr = GetCommandFromDBSession( pIDBCreateCommand, &pICommand );
    if (FAILED(hr))
        {
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "GetCommandFromDBCreateSession" );
        goto error;
        }

    pIDBCreateCommand->Release();
    pIDBCreateCommand = NULL;    

    hr = pICommand->QueryInterface( IID_ICommandText, (void**)&pICommandText);
    if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "ICommand::QI for ICommandText");
        goto error;
        }

	// Do tests
	hr = TestCommand( pICommand, pICommandText );
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "TestDataFromRowset" );
        goto error;
        }

    pICommandText->Release(); 
    pICommandText = NULL;
    pICommand->Release(); 
    pICommand = NULL;
	CoFreeUnusedLibraries();

	DumpStatusMsg( "\nDone! ");
	printf("\n\nFor more data from this run, see the log file \n" );	
	return ResultFromScode( S_OK );
    
error:    
	if (pICommandText) 
		pICommandText->Release();
	if (pICommand) 
		pICommand->Release();
    if (pIDBCreateCommand)
        pIDBCreateCommand->Release();    
    if (pIDBInitialize)
    	pIDBInitialize->Release();	    
	
	return ResultFromScode( hr );
}						    





//**********************************************************************
//  
// GetSampprovDataSource
// 
// Purpose:
//
//     Calls OLE to find and load the MYSQLPROV data provider. 
//     Returns an IDBInitialize interface pointer on MYSQLPROV's 
//     Data Source object.
//
// Parameters:
// 	
//   IDBInitialize** ppIDBInitialize_out  - out pointer through which to return
// 									        IDBInitialize pointer on data 
//								            provider's Data Source object 	
// 
// Return Value:
// 
// 	S_OK		- Success
//  E_*	    	- Failure
//     
//
// Comments:      
// 
//     The call to CoCreateInstance is hard-coded with MYSQLPROV's CLSID.
//     The pointer returned through ppIDBInitialize_out has been AddRef'ed,
//     it must be Release'd later by the caller.
//  
//**********************************************************************

HRESULT GetSampprovDataSource
	(
	IDBInitialize**	ppIDBInitialize_out
	)
{
	IDBInitialize*	pIDBInit = NULL;
	IDBProperties*	pIDBProperties = NULL;
	DBPROPSET		dbPropSet[1];
	DBPROP			dbProp[1];

	HRESULT	hr;


	DumpStatusMsg( "Connecting to the MySqlProv sample data provider...\n" );

	assert(ppIDBInitialize_out != NULL);

	VariantInit(&(dbProp[0].vValue));

	// Create an instance of the MySqlProv sample data provider
	hr = CoCreateInstance( CLSID_MySqlProv, NULL, CLSCTX_INPROC_SERVER, 
				IID_IDBInitialize, (void **)&pIDBInit ); 
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "CoCreateInstance" );
        goto error;
        }

	// Initialize this provider with the mysql database connection string
	dbPropSet[0].rgProperties		= &dbProp[0];
	dbPropSet[0].cProperties		= 1;
	dbPropSet[0].guidPropertySet	= DBPROPSET_DBINIT;
	
	dbProp[0].dwPropertyID			= DBPROP_INIT_DATASOURCE;
	dbProp[0].dwOptions				= DBPROPOPTIONS_REQUIRED;
	dbProp[0].colid					= DB_NULLID;
	V_VT(&(dbProp[0].vValue))		= VT_BSTR;
	V_BSTR(&(dbProp[0].vValue))		= SysAllocString( DEF_MYSQL_CONN );
    if ( NULL == V_BSTR(&(dbProp[0].vValue)) )
        {
        DUMP_ERROR_LINENUMBER();
        DumpErrorMsg( "SysAllocString failed\n" );
        goto error;
        }

    hr = pIDBInit->QueryInterface( IID_IDBProperties, (void**)&pIDBProperties);
    if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "IDBInitialize::QI for IDBProperties");
        goto error;
        }

	hr = pIDBProperties->SetProperties( 1, &dbPropSet[0]);
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "IDBProperties::SetProperties" );
        goto error;
        }
		
	hr = pIDBInit->Initialize();
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "IDBInitialize::Initialize" );
        goto error;
        }

	*ppIDBInitialize_out = pIDBInit;

	hr = ResultFromScode( S_OK );

error:    
    VariantClear( &(dbProp[0].vValue) );

	if( pIDBProperties )
		pIDBProperties->Release();

	if( FAILED(hr) )
	{
		if (pIDBInit)
    		pIDBInit->Release();
		*ppIDBInitialize_out = NULL;
	}

	return hr;    
}




//  **********************************************************************
//
// GetDBSessionFromDataSource
//
// Purpose:
//      Calls the provider's Data Source object to get an IOpenRowset interface
//      pointer on a DBSession object.  
//      
// Parameters:
//      pIDBInitialize      - pointer to Data Source object
//      ppIDBCreateCommand_out   - out pointer through which to return 
//                                 IDBCreateCommand pointer on DBSession object
//
// Return Value: 
//
// 	S_OK		- Success
//  E_*	    	- Failure
//
//
// Comments:
//
//      The interface pointer returned through ppIOpenRowset_out has been 
//      AddRef'ed, the caller must Release it later.
//
//**********************************************************************

HRESULT GetDBSessionFromDataSource
    (
    IDBInitialize*      pIDBInitialize,      // [in]
    IDBCreateCommand**  ppIDBCreateCommand_out    // [out]
    )
{
    IDBCreateSession*   pIDBCreateSession;
    IDBCreateCommand*   pIDBCreateCommand;
    HRESULT             hr;


    DumpStatusMsg( "Getting a DBSession object from the data source object...\n" );
    
    assert(pIDBInitialize != NULL);
    assert(ppIDBCreateCommand_out  != NULL );

    hr = pIDBInitialize->QueryInterface( IID_IDBCreateSession, (void**)&pIDBCreateSession);
    if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "IDBInitialize::QI for IDBCreateSession");
        goto error;
        }
        
    hr = pIDBCreateSession->CreateSession( NULL, IID_IDBCreateCommand, (IUnknown**)&pIDBCreateCommand );    
    if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "IDBCreateSession::CreateSession");
        goto error;
        }
     pIDBCreateSession->Release();
     pIDBCreateSession = NULL;
     
     // all went well
     *ppIDBCreateCommand_out = pIDBCreateCommand;
     return ResultFromScode( S_OK );
     
error:
    if (pIDBCreateSession)
        pIDBCreateSession->Release();
        
    *ppIDBCreateCommand_out = NULL;    
    return ResultFromScode( hr );
}



//**********************************************************************
//
// GetCommandFromDBSession
//
// Purpose:
//      Calls the provider's DBSession object to get an ICommand interface
//      pointer on a Rowset object.  
//      
// Parameters:
//      pIDBCreateCommand        - interface pointer on DBSession object
//      ppICommand_out           - out pointer through which to return 
//                                 ICommand pointer on Command object
//
// Return Value: 
//
// 	S_OK		- Success
//  E_*	    	- Failure
//
// Comments:
//
//      The interface pointer returned through ppICommand_out has been 
//      AddRef'ed, the caller must Release it later.
//
///**********************************************************************

HRESULT GetCommandFromDBSession
    (
    IDBCreateCommand*   pIDBCreateCommand,    // [in]
    ICommand**          ppICommand_out    // [out]
    )
{
    ICommand*       pICommand = NULL;
    HRESULT         hr;

    DumpStatusMsg( "Getting a command object from the DBSession object...\n" );
    
    assert(pIDBCreateCommand != NULL);
    assert(ppICommand_out  != NULL );
        
    hr = pIDBCreateCommand->CreateCommand
                        (
                        NULL,                   // pUnkOuter - we are not aggregating
                        IID_ICommand,           // riid - interface we want on the command object
                        (IUnknown**)&pICommand  // ppCommand
                        );
    if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr, "IDBCreateCommand::CreateCommand" );
        goto error;
        }
    
    // all went well
    *ppICommand_out = pICommand;
    return ResultFromScode( S_OK );

error:
    if (pICommand)
        pICommand->Release();
    *ppICommand_out = NULL;            
    
    return ResultFromScode( hr );
}    


//**********************************************************************
// 
// TestCommand
// 
// Purpose:
// 
//     Performd varios tests over the data from a Command object.
//     
// Parameters:
// 
// 	ICommand*	pICommand    -  interface pointer on data provider's
//                              Command object
// 	ICommandText*	pICommandText    -  interface pointer on data provider's
//										Command object
// 
// Return Value:
// 
//     S_OK        - Success
//     E_*         - Failure
// 
//**********************************************************************

HRESULT TestCommand
	(
	ICommand*		pICommand,
	ICommandText*	pICommandText
	)
{
	long		cRowsAffected = 0;
	IRowset*	pIRowset = NULL;
	char        buf[200];
	HRESULT		hr;

	assert(pICommand != NULL);
	assert(pICommandText != NULL);

	/////
	DumpStatusMsg( "Preparing for the test....\n" );
	hr = pICommandText->SetCommandText( DBGUID_DBSQL, DROP_TABLE_QUERY );
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr,  "SetCommandText");
        goto error;
        }

	pICommand->Execute( NULL, IID_IRowset, NULL, &cRowsAffected, (IUnknown**)&pIRowset );
	assert (pIRowset==NULL);
	/////

	DumpStatusMsg( "Creating table " TEST_TABLE "...\n" );

	hr = pICommandText->SetCommandText( DBGUID_DBSQL, CREATE_TABLE_QUERY );
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr,  "SetCommandText");
        goto error;
        }

	hr = pICommand->Execute( NULL, IID_IRowset, NULL, &cRowsAffected, (IUnknown**)&pIRowset );
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr,  "Execute(CREATE TABLE) failed. Possibly, table exists");
        goto error;
        }
	assert (cRowsAffected==0 && pIRowset==NULL);
	assert (pIRowset==NULL);
	if( pIRowset ) goto error;
	cRowsAffected = 0;

	DumpStatusMsg( "Adding a row to " TEST_TABLE "...\n" );

	hr = pICommandText->SetCommandText( DBGUID_DBSQL, INSERT_ROW_QUERY );
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr,  "SetCommandText");
        goto error;
        }

	hr = pICommand->Execute( NULL, IID_IRowset, NULL, &cRowsAffected, (IUnknown**)&pIRowset );
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr,  "Execute(INSERT)");
        goto error;
        }

	sprintf( buf, "INSERT: %ld row(s) affected\n", cRowsAffected );
	DumpStatusMsg( buf );
	
	assert (cRowsAffected==1 && pIRowset==NULL);	
	assert (pIRowset==NULL);
	if( pIRowset ) goto error;
	cRowsAffected = 0;

	DumpStatusMsg( "Dropping table " TEST_TABLE "...\n" );

	hr = pICommandText->SetCommandText( DBGUID_DBSQL, DROP_TABLE_QUERY );
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr,  "SetCommandText");
        goto error;
        }

	hr = pICommand->Execute( NULL, IID_IRowset, NULL, &cRowsAffected, (IUnknown**)&pIRowset );
	if (FAILED(hr))
    	{
        DUMP_ERROR_LINENUMBER();
        DumpErrorHResult( hr,  "Execute(DROP TABLE) failed. Possibly, table does not exist" );
        goto error;
        }

	assert (cRowsAffected==0 && pIRowset==NULL);
	if( pIRowset ) goto error;
	cRowsAffected = 0;
	
	return ResultFromScode( S_OK );		
    
error:    
	if (pIRowset)
		pIRowset->Release();
	    
    return ResultFromScode( hr );   
}




